/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.connserv;

import com.ibm.hwmca.fw.connserv.CommPath;
import com.ibm.hwmca.fw.connserv.ConnServException;
import com.ibm.hwmca.fw.connserv.DialupTcpConnectionInfo;
import com.ibm.hwmca.fw.connserv.DialupTcpConnectionParms;
import com.ibm.hwmca.fw.connserv.DirectTcpConnectionInfo;
import com.ibm.hwmca.fw.connserv.DirectTcpConnectionParms;
import com.ibm.hwmca.fw.connserv.FailedToConnectException;
import com.ibm.hwmca.fw.connserv.PathRequestInfo;
import com.ibm.hwmca.fw.connserv.PathVerifier;
import com.ibm.hwmca.fw.connserv.TcpConnectionInfo;
import com.ibm.hwmca.fw.connserv.TcpConnectionParms;
import com.ibm.hwmca.fw.connserv.UnableToFulfillException;
import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class TcpCommPath
extends CommPath {
    private static final String TRACE_T = "XRCSTCPT";
    private static final String TRACE_F = "XRCSTCPF";
    private PathVerifier pathVerifier;
    private ArrayList connectionParms;
    private TcpConnectionInfo connectionInfo;
    private ListIterator parmsIter;
    private boolean connected;
    private ArrayList sockets;
    private boolean directConnect = false;

    public TcpCommPath(int priority, PathRequestInfo requestInfo) throws IllegalArgumentException {
        super(priority, requestInfo);
        Trace.trace(TRACE_T, "<> TcpCommPath ctor created path #" + this.getId());
    }

    public void setConnectionParameters(List parameters) throws IllegalStateException, IllegalArgumentException {
        Trace.trace(TRACE_T, "-> setConnectionParameters() for path #" + this.getId());
        if (parameters == null || parameters.isEmpty()) {
            Trace.trace(TRACE_T, "<- setConnectionParameters() EXC: Called with invalid paramters");
            throw new IllegalArgumentException("The connection parameters list is null or emptyl");
        }
        int st = this.getState();
        if (st != 0) {
            Trace.trace(TRACE_T, "<- setConnectionParameters() EXC: Path state is wrong");
            throw new IllegalStateException("CommPath is not in the 'new' state");
        }
        Iterator iter = parameters.iterator();
        while (iter.hasNext()) {
            Object elem = iter.next();
            if (elem instanceof TcpConnectionParms) continue;
            this.connectionParms = null;
            Trace.trace(TRACE_T, "<- setConnectionParameters() EXC: Parameters list contains invalid object");
            throw new IllegalArgumentException("Connection parameters list contains an invalid object");
        }
        this.connectionParms = new ArrayList();
        this.connectionParms.addAll(parameters);
        Trace.trace(TRACE_T, "<- setConnectionParameters() Ok");
    }

    public synchronized void setPathVerifier(PathVerifier verifier) throws IllegalStateException {
        Trace.trace(TRACE_T, "-> setPathVerifier() for path #" + this.getId());
        int state = this.getState();
        if (state != 0 && state != 2) {
            Trace.trace(TRACE_T, "<- setPathVerifier() EXC: Path state is wrong");
            throw new IllegalStateException("Path is not in the new or available state");
        }
        if (verifier != null && this.pathVerifier != null) {
            Trace.trace(TRACE_T, "Hmm, we're replacing an existing path verifier.");
        }
        this.pathVerifier = verifier;
        Trace.trace(TRACE_T, "<- setPathVerifier() Ok");
    }

    public Socket getSocket() throws IOException, IllegalStateException {
        Trace.trace(TRACE_T, "-> getSocket() for path #" + this.getId());
        if (super.getState() != 4) {
            Trace.trace(TRACE_T, "<- getSocket() EXC: Path state wrong");
            throw new IllegalStateException("Path is not in the opened state");
        }
        Socket s = null;
        try {
            s = new Socket(this.connectionInfo.getIpAddress(), this.connectionInfo.getPort());
        }
        catch (IOException e) {
            Trace.trace(TRACE_T, "<- getSocket() EXC: Unable to create new socket");
            throw e;
        }
        this.sockets.add(s);
        Trace.trace(TRACE_T, "<- getSocket() Ok, returning new socket");
        return s;
    }

    public TcpConnectionInfo getConnectionInfo() throws IllegalStateException {
        Trace.trace(TRACE_T, "-> getConnectionInfo() for path #" + this.getId());
        if (super.getState() != 4) {
            Trace.trace(TRACE_T, "<- setConnectionParameters() EXC: Path state wrong");
            throw new IllegalStateException("Path is not in the opened state");
        }
        Trace.trace(TRACE_T, "<- getConnectionInfo() Ok, returning info: " + this.connectionInfo.toString());
        return this.connectionInfo;
    }

    public boolean isHighPerformancePath() {
        return this.directConnect;
    }

    protected void allocateResources() throws ConnServException {
        Trace.trace(TRACE_T, "-> allocateResources() for path #" + this.getId());
        if (this.connectionParms == null) {
            Trace.trace(TRACE_T, "<- allocateResources() EXC: No connection parameters were set");
            throw new UnableToFulfillException("Connection parameters were not set");
        }
        Trace.trace(TRACE_T, "<- allocateResources() Ok (stub impl)");
    }

    protected void freeResources() throws ConnServException {
        Trace.trace(TRACE_T, "-> freeResources() for path #" + this.getId());
        Trace.trace(TRACE_T, "<- freeResources() Ok (stub impl)");
    }

    protected void cancelAllocateResources() throws ConnServException {
        Trace.trace(TRACE_T, "-> cancelAllocateResources() for path #" + this.getId());
        Trace.trace(TRACE_T, "<- cancelAllocateResources() Ok (stub impl)");
    }

    protected void establishLink() throws ConnServException {
        Trace.trace(TRACE_T, "-> establishLink() for path #" + this.getId());
        this.connected = false;
        if (this.parmsIter == null) {
            this.parmsIter = this.connectionParms.listIterator();
        }
        while (!this.connected && this.parmsIter.hasNext()) {
            TcpConnectionInfo connInfo;
            Trace.trace(TRACE_T, "Trying direct connect for  alternative #" + this.parmsIter.nextIndex());
            boolean mustDial = false;
            Socket socket = null;
            TcpConnectionParms parms = (TcpConnectionParms)this.parmsIter.next();
            String parmsIpAddr = parms.getIpAddress();
            int parmsPortNr = parms.getPort();
            mustDial = false;
            if (!(parms instanceof DirectTcpConnectionParms) && mustDial) {
                Trace.trace(TRACE_T, "This alternative is must-dial, skipping direct connect");
                continue;
            }
            try {
                Trace.trace(TRACE_T, "Trying direct connect to " + parmsIpAddr + ", port " + parmsPortNr);
                socket = new Socket(parmsIpAddr, parmsPortNr);
            }
            catch (UnknownHostException e) {
                Trace.trace(TRACE_T, "Unresolvable/invalid IP address: " + parmsIpAddr);
                continue;
            }
            catch (IOException e) {
                Trace.trace(TRACE_T, "Direct connect didn't work");
                continue;
            }
            Trace.trace(TRACE_T, "Connection established");
            this.directConnect = true;
            if (parms instanceof DialupTcpConnectionParms) {
                Trace.trace(TRACE_T, "Connection is a keeper, constructing Dialup connection parms");
                DialupTcpConnectionParms duParms = (DialupTcpConnectionParms)parms;
                connInfo = new DialupTcpConnectionInfo(duParms.getIpAddress(), duParms.getPort(), duParms.getExtraInfoObject(), duParms.getPhoneNumber(), duParms.getIspLogin(), "RCS-0.1");
            } else {
                Trace.trace(TRACE_T, "Connection is a keeper, constructing Direct connection parms");
                DirectTcpConnectionParms dParms = (DirectTcpConnectionParms)parms;
                connInfo = new DirectTcpConnectionInfo(dParms.getIpAddress(), dParms.getPort(), dParms.getExtraInfoObject());
            }
            if (this.pathVerifier != null) {
                try {
                    this.pathVerifier.verifyConnection(this, connInfo, socket);
                }
                catch (FailedToConnectException e) {
                    Trace.trace(TRACE_T, "Path verifier was unhappy with connection, closing it");
                    try {
                        socket.close();
                    }
                    catch (IOException ee) {}
                    continue;
                }
                catch (Exception e) {
                    Trace.trace(TRACE_T, "Path verifier threw unexpected exception, closing tentative connection");
                    try {
                        socket.close();
                    }
                    catch (IOException ee) {}
                    continue;
                }
            }
            this.connected = true;
            this.sockets = new ArrayList(1);
            this.sockets.add(socket);
            this.connectionInfo = connInfo;
        }
        if (!this.connected) {
            Trace.trace(TRACE_T, "<- establishLink() EXC: All connection alternatives failed");
            throw new UnableToFulfillException("Could not establish connection; all alternatives failed");
        }
        Trace.trace(TRACE_T, "<- establishLink() Ok");
    }

    protected void terminateLink() throws ConnServException {
        Trace.trace(TRACE_T, "-> terminateLink() for path #" + this.getId());
        Trace.trace(TRACE_T, "Closing " + this.sockets.size() + " socket(s) associated with this path");
        Iterator iter = this.sockets.iterator();
        while (iter.hasNext()) {
            Socket s = (Socket)iter.next();
            try {
                s.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        Trace.trace(TRACE_T, "<- terminateLink() Ok");
        this.connected = false;
        this.connectionInfo = null;
        this.sockets = null;
    }

    protected void cancelEstablishLink() throws ConnServException {
        Trace.trace(TRACE_T, "-> cancelEstablishLink() for path #" + this.getId());
        Trace.trace(TRACE_T, "<- cancelEstablishLink() Ok (stub impl)");
    }
}

